// This program must be compiled on a Japanese system.

import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.net.*;
import java.applet.*;
import java.util.*;

final public class KanaNumber extends Applet implements Runnable, KeyListener, ActionListener, ItemListener, AdjustmentListener
{  boolean _fInit = false, _fError = false;
   final private static int ModeModern = 0, ModeTraditional = 1, ModeDate = 2;
   int _iMode = ModeModern;
   Thread _thread = null;
   FontMetrics _fm;
   String _strNumber = "", _strNumberAndNoun = "", _strReading = "";
   String _astrPhonemes[], _astrRoman[];
   Panel _panel;
   Choice _choiceFont;
   Scrollbar _scrollbar;
   Hashtable _hashImg;

   int _iImgSize = 0;
   int _cxString1, _cxString2, _iAscent, _iDescent;
   int _iScroll = 0;

   static Hashtable _hashKana, _hashPhon, _hashRoman;
   static int _cKana = makeHash();

   final static String _strWait = "Now loading images...";
   final static String _strError = "Image load error!";
   final static String _astrFonts[] =
   {  "Gothic", "Kaisho", "MaruGothic", "Mincho", "Pop", "Textbook"
   };

   String _strFont = "Textbook";
   boolean _fKata = false;
   final static String _strClear = "Clear";
   final static String _strKana = "ĂƂÂłǂȂɂʂ˂̂͂Ђӂւق΂тԂׂڂς҂Ղ؂ۂ܂݂ނ߂傟[";

   final static String _strHashKana = ",a,,i,,u,,e,,o,,ka,,ki,,ku,,ke,,ko,,ga,,gi,,gu,,ge,,go,,sa,,si,,su,,se,,so,,za,,zi,,zu,,ze,,zo,,ta,,ti,,tu,,te,,to,,da,,di,,du,,de,,do,,na,,ni,,nu,,ne,,no,,ha,,hi,,hu,,he,,ho,,ba,,bi,,bu,,be,,bo,,pa,,pi,,pu,,pe,,po,,ma,,mi,,mu,,me,,mo,,ya,,yu,,yo,,ra,,ri,,ru,,re,,ro,,wa,,wi,,we,,wo,,N,,Q,,kya,,kyu,,kyo,,gya,,gyu,,gyo,,sya,,syu,,syo,,zya,,zyu,,zyo,,tya,,tyu,,tyo,,dya,,dyu,,dyo,ɂ,nya,ɂ,nyu,ɂ,nyo,Ђ,hya,Ђ,hyu,Ђ,hyo,т,bya,т,byu,т,byo,҂,pya,҂,pyu,҂,pyo,݂,mya,݂,myu,݂,myo,,rya,,ryu,,ryo";

   final static String _strhashRoman = "sya,sha,si,shi,syu,shu,syo,sho,zya,ja,zi,ji,zyu,ju,zyo,jo,tya,cha,ti,chi,tyu,chu,tyo,cho,tu,tsu,dya,ja,dyu,ju,dyo,jo,di,ji,du,zu,hu,fu,N,n";

   final static String _strDigits[] =
   {  "ꂢ", "", "", "", "", "", "낭", "Ȃ", "͂", "イ"
   };

   final static String _strSmallUnits[] =
   {  "", "イ", "ЂႭ", ""
   };

   final static String _strLargeUnits[] =
   {  "", "܂", "", "傤", "", "", "", "傤", "", "", "",
      "", "", "", "", "Ȃ䂽", "ӂ", "ނ傤", ""
   };

   final static String _strTradDigits[] =
   {  "", "ЂƂ", "ӂ", "݂", "",
      "", "ނ", "ȂȂ", "", "̂"
   };

   final static String _strTradPrefix[] =
   {  "", "", "ӂ", "", "", "", "", "Ȃ", "", ""
   };

   final static String _strRemain = "܂";

   final static String _strDates[] =
   {  "", "", "ӂ", "݂", "",
      "", "ނ", "Ȃ̂", "悤", "̂", "Ƃ"
   };

   final static String _strNoCounter = "no counter";
   final static String _strHashCounters = "people,ɂ,animates,Ђ,inanimates,,large animals,Ƃ,birds,,long things,ق,thin things,܂,books,,cups,͂,lifelikes,,machines,,ships,,yen,,traditional,t,day of the month,d";

   static Hashtable _hashCounters;
   static String _astrCounters[];
   String _strNoun, _strCounter;

   final private static int makeHash()
   {  _hashPhon = new Hashtable();
      _hashKana = new Hashtable();
      int cKana = 0;

      StringTokenizer st = new StringTokenizer(_strHashKana, ",");
      while (st.hasMoreTokens())
      {  String strKana = st.nextToken(), strAlpha = st.nextToken();
	 _hashPhon.put(strAlpha, strKana);
	 _hashKana.put(strKana, strAlpha);
	 cKana++;
      }

      Vector vector = new Vector();
      vector.addElement(_strNoCounter);
      _hashCounters = new Hashtable();
      st = new StringTokenizer(_strHashCounters, ",");

      while (st.hasMoreTokens())
      {  String strCategory = st.nextToken();
	 vector.addElement(strCategory);
	 _hashCounters.put(strCategory, st.nextToken());
      }

      vector.copyInto(_astrCounters = new String[vector.size()]);

      _hashRoman = new Hashtable();
      st = new StringTokenizer(_strhashRoman, ",");
      while (st.hasMoreTokens())
      {  _hashRoman.put(st.nextToken(), st.nextToken());
      }

      return cKana;
   }

   final public void init()
   {  Color color = new Color(0xf0, 0xf4, 0xf1);
      setBackground(color);

      Panel panel = _panel = new Panel();
      panel.setBackground(color);
      panel.setLayout(new GridLayout(1, 3));

      Choice choice = new Choice();
      for (int iIndex = 0; iIndex < _astrFonts.length; iIndex++)
      {  choice.addItem(_astrFonts[iIndex] + ", Hiragana");
	 choice.addItem(_astrFonts[iIndex] + ", Katakana");
      }

      choice.select(_strFont + ", Hiragana");
      choice.addItemListener(this);
      panel.add(_choiceFont = choice);

      choice = new Choice();
      for (int iIndex = 0; iIndex < _astrCounters.length; iIndex++)
      {  choice.addItem(_astrCounters[iIndex]);
      }

      panel.add(choice);
      choice.addItemListener(this);

      Button button = new Button(_strClear);
      panel.add(button);
      button.addActionListener(this);

      add(panel);
      add(_scrollbar = new Scrollbar(Scrollbar.HORIZONTAL, 0, 1, 0, 0));
      _scrollbar.addAdjustmentListener(this);

      Font fontNew = new Font("serif", Font.BOLD, 32),
           fontOld = getFont();
      setFont(fontNew);
      panel.setFont(fontOld);
      FontMetrics fm = _fm = getFontMetrics(fontNew);
      _cxString1 = fm.stringWidth(_strWait);
      _cxString2 = fm.stringWidth(_strError);
      _iAscent = fm.getMaxAscent();
      _iDescent = fm.getMaxDescent();

      if (!_fInit && !_fError && _thread == null)
      {  (_thread = new Thread(this)).start();
      }

      addKeyListener(this);
   }

   final public void start()
   {  requestFocus();
   }

   final private void setScrollbar()
   {  int iCharacters = Math.max(_fm.stringWidth(_strNumberAndNoun),
				 _strReading.length() * _iImgSize),
	  iScrollbarWidth = _scrollbar.getSize().width;
      int iVisible = Math.min(iCharacters, iScrollbarWidth);
      int iOffset = Math.min(iCharacters - iVisible, _iScroll);
      _scrollbar.setValues(iOffset, iScrollbarWidth, 0, iCharacters);
      _scrollbar.setBlockIncrement(iVisible);
      _iScroll = iOffset;
   }

   final public synchronized void doLayout()
   {  if (_panel != null)
      {  Dimension dimWindow = getSize();
	 int iWidth = dimWindow.width, iHeight = dimWindow.height;
	 _panel.setLocation(0, 0);
	 _panel.setSize(iWidth, Math.min(iHeight / 4, _panel.getPreferredSize().height));

	 if (_scrollbar != null)
	 {  int iScrollbarHeight = _scrollbar.getPreferredSize().height;
	    _scrollbar.setLocation(0, iHeight - iScrollbarHeight);
	    _scrollbar.setSize(iWidth, iScrollbarHeight);
	    setScrollbar();
	 }
      }
   }

   final public void run()
   {  try
      {  Image image = getImage(getCodeBase(),
				_strFont.toLowerCase() + (_fKata ? "_k.gif" : ".gif"));
	 MediaTracker media = new MediaTracker(this);
	 media.addImage(image, 0);
	 media.waitForAll();

	 if (media.isErrorAny())
	 {  _fError = true;
	 }
	 else
	 {  int cImages = _strKana.length(),
	        iImgSize = _iImgSize = image.getHeight(this);
	    ImageProducer imgprod = image.getSource();
	    _hashImg = new Hashtable();

	    for (int iIndex = 0; iIndex < cImages; iIndex++)
	    {  _hashImg.put(new Character(_strKana.charAt(iIndex)),
			    createImage(new FilteredImageSource
					(imgprod,
					 new CropImageFilter(iIndex * iImgSize, 0,
							     iImgSize, iImgSize))));
	    }

	    _scrollbar.setUnitIncrement(iImgSize);
	    _fInit = true;
	 }
      }
      catch (Exception e)
      {  _fError = true;
      }

      _thread = null;
      repaint();
   }

   final public void paint(Graphics g)
   {  Dimension dimWindow = getSize();
      int yOffset = _panel.getSize().height;
      int cx = dimWindow.width, cy = dimWindow.height - yOffset - _scrollbar.getSize().height;
      int iAscent = _iAscent, iDescent = _iDescent;
      int yString = (cy + iAscent - iDescent) / 2 + yOffset;

      if (_fError)
      {  g.drawString(_strError, (cx - _cxString2) / 2, yString);
      }
      else if (_fInit)
      {  int x = -_iScroll;
	 g.drawString(_strNumberAndNoun, x, iAscent + yOffset);

	 int yRoman = cy - iDescent + yOffset,
	     yPhoneme = yRoman - iAscent - iDescent,
	     yImage = yPhoneme - iAscent - _iImgSize;
	 int cChars = _strReading.length();

	 drawStrings(g, _astrPhonemes, x, yPhoneme);
	 drawStrings(g, _astrRoman, x, yRoman);

	 for (int iIndex = 0; iIndex < cChars; iIndex++)
	 {  g.drawImage((Image)_hashImg.get(new Character(_strReading.charAt(iIndex))),
			x, yImage, this);
	    x += _iImgSize;
	 }
      }
      else
      {  g.drawString(_strWait, (cx - _cxString1) / 2, yString);
      }
   }

   final private void drawStrings(Graphics g, String astr[], int x, int y)
   {  if (astr == null)
      {  return;
      }

      int iNextDraw = 0;
      for (int iIndex = 0; iIndex < astr.length; iIndex++)
      {  String str = astr[iIndex];
	 if (str != null)
	 {  g.drawString(str,
			 x + (_iImgSize * (iNextDraw + iIndex + 1) - _fm.stringWidth(str)) / 2,
			 y);
	    iNextDraw = iIndex + 1;
	 }
      }
   }

   final private static String groupNumber(int iNumber)
   {  StringBuffer sb = new StringBuffer();

      for (int iIndex = 0; iIndex <= 3; iIndex++)
      {  int iDigit;
	 if ((iDigit = iNumber % 10) != 0)
	 {  sb.insert(0, ((iDigit >= 2 || (iDigit == 1 && iIndex == 0))
			  ? combineNumber(_strDigits[iDigit], _strSmallUnits[iIndex])
			  : _strSmallUnits[iIndex]));
	 }

	 iNumber /= 10;
      }

      return sb.toString();
   }

   final private static String modernNumber(String strNumber, String strCounter)
   {  int cbLength = strNumber.length();
      String strInteger, strDecimal;
      int iDecimal, cbDecimal;

      if ((iDecimal = strNumber.indexOf('.')) >= 0)
      {  strInteger = strNumber.substring(0, iDecimal);
	 strDecimal = strNumber.substring(iDecimal + 1);
	 cbDecimal = cbLength - iDecimal - 1;
	 cbLength = iDecimal;
      }
      else
      {  strInteger = strNumber;
	 strDecimal = null;
	 cbDecimal = 0;
      }

      StringBuffer sb = new StringBuffer();
      for (int iIndex = 0; iIndex < cbLength; iIndex += 4)
      {  int iGroup = Integer.parseInt(strInteger.substring(Math.max(cbLength - iIndex - 4, 0),
							    cbLength - iIndex));
	 if (iGroup != 0)
	 {  sb.insert(0, combineNumber(groupNumber(iGroup),
				       _strLargeUnits[iIndex / 4]));
	 }
      }

      if (sb.length() == 0)
      {  sb.append(_strDigits[0]);
      }

      if (cbDecimal > 0)
      {  char cDigit = strInteger.charAt(cbLength - 1);
	 if (cDigit == '2' || cDigit == '5')
	 {  sb.append('[');
	 }
	 else if (cDigit == '1'
		  || cDigit == '8'
		  || (cDigit == '0'
		      && cbLength >= 2
		      && strInteger.charAt(cbLength - 2) != '0'))
	 {  sb.setCharAt(sb.length() - 1, '');
	 }

	 sb.append("Ă");

	 for (int iIndex = 0; iIndex < cbDecimal; iIndex++)
	 {  cDigit = strDecimal.charAt(iIndex);
	    sb.append(_strDigits[cDigit - '0']);

	    if (iIndex < (cbDecimal & ~1))
	    {  if (cDigit == '2' || cDigit == '5')
	       {  sb.append('[');
	       }
	    }
	 }
      }

      if (strCounter != null)
      {  char c;

	 if (cbDecimal == 0
	     && cbLength == 1
	     && strCounter.equals("ɂ")
	     && ((c = strInteger.charAt(0)) == '1' || c == '2'))
	 {  return (c == '1' ? "ЂƂ" : "ӂ");
	 }
	 else if (cbDecimal <= 1
		  && !strInteger.endsWith("00000000"))  // "" or more
	 {  return combineNumber(sb.toString(), strCounter);
	 }

	 sb.append(strCounter);
      }

      return sb.toString();
   }

   final private static String traditionalNumber(String strNumber)
   {  StringBuffer sb = new StringBuffer();
      int iNumber = Integer.parseInt(strNumber);
      if (iNumber >= 10000)
      {  sb.append(_strTradPrefix[iNumber / 10000]).append("낸");
	 iNumber %= 10000;
      }

      if (iNumber >= 1000)
      {  if (sb.length() > 0)
	 {  sb.append(_strRemain);
	 }

	 sb.append(_strTradPrefix[iNumber / 1000]).append("");
	 iNumber %= 1000;
      }

      if (iNumber >= 100)
      {  if (sb.length() > 0)
	 {  sb.append(_strRemain);
	 }

	 int iDigit = iNumber / 100;
	 if (iDigit == 1)
	 {  sb.append("");
	 }
	 else
	 {  sb.append(_strTradPrefix[iDigit]).append("");
	 }

	 iNumber %= 100;
      }

      if (iNumber >= 10)
      {  if (sb.length() > 0)
	 {  sb.append(_strRemain);
	 }

	 int iDigit = iNumber / 10;
	 if (iDigit == 1)
	 {  sb.append("Ƃ");
	 }
	 else if (iDigit == 2)
	 {  sb.append("͂");
	 }
	 else
	 {  sb.append(_strTradPrefix[iDigit]).append("");
	 }

	 iNumber %= 10;
      }

      if (iNumber >= 1)
      {  if (sb.length() > 0)
	 {  sb.append(_strRemain);
	 }

	 sb.append(_strTradDigits[iNumber]);
      }

      return sb.toString();
   }

   final private static String dateNumber(String strNumber)
   {  int iNumber = Integer.parseInt(strNumber);
      if (iNumber <= 10)
      {  return _strDates[iNumber];
      }
      else if (iNumber == 20)
      {  return "͂";
      }

      StringBuffer sb = new StringBuffer();
      if (iNumber >= 10)
      {  if (iNumber >= 20)
	 {  sb.append(_strDigits[iNumber / 10]);
	 }

	 sb.append(_strSmallUnits[1]);
	 iNumber = iNumber % 10;
      }

      if (iNumber == 4)
      {  sb.append(_strDates[4]);
      }
      else
      {  if (iNumber != 0)
	 {  sb.append(_strDigits[iNumber]);
	 }

	 sb.append("ɂ");
      }

      return sb.toString();
   }

   final private static String combineNumber(String strNumber, String strUnit)
   {  int cbNumber;
      if ((cbNumber = strNumber.length()) == 0)
      {  return strUnit;
      }

      int cbUnit;
      if ((cbUnit = strUnit.length()) == 0)
      {  return strNumber;
      }

      StringBuffer sb = new StringBuffer(strNumber);
      if (cbUnit >= 4)
      {  return sb.append(strUnit).toString();
      }

      char acFirstSyllable[] = ((String)_hashKana.get(strUnit.substring(0, 1))).toCharArray(),
           cFirstPhoneme = acFirstSyllable[0],
           cLastKana = strNumber.charAt(cbNumber - 1);

      if (cLastKana == '')
      {  if (strNumber.endsWith(_strDigits[4]))  // ""
	 {  if (cFirstPhoneme == 'n')
	    {  sb.setLength(--cbNumber);
	    }
	 }
         else if (cFirstPhoneme == 'h')
	 {  cFirstPhoneme = 'b';
	 }
         else if (strUnit.equals(_strSmallUnits[3])) // ""
	 {  cFirstPhoneme = 'z';
	 }
      }
      else if (cLastKana == '')
      {  switch (cFirstPhoneme)
	 {  case 'h':
	       cFirstPhoneme = 'p';
	    case 'k':
	       sb.setCharAt(cbNumber - 1, '');
	       break;
	 }
      }
      else if (cLastKana == ''
	       || strNumber.endsWith("イ"))
      {  switch (cFirstPhoneme)
	 {  case 'h':
	       cFirstPhoneme = 'p';
	    case 'k':
	    case 's':
	    case 't':
	       sb.setCharAt(cbNumber - 1, '');
	       break;
	 }
      }

      sb.append(strUnit);

      acFirstSyllable[0] = cFirstPhoneme;
      sb.setCharAt(cbNumber, ((String)_hashPhon.get(new String(acFirstSyllable))).charAt(0));

      return sb.toString();
   }

   final private static String[] getPhoneme(String strKana)
   {  int cKana = strKana.length();
      if (cKana == 0)
      {  return null;
      }

      String astr[] = new String[cKana];

      for (int iIndex = 0; iIndex < cKana; iIndex++)
      {  String str = strKana.substring(iIndex, iIndex + 1);
	 if ((astr[iIndex] = (String)_hashKana.get(str)) == null)
	 {  if (str.equals("["))
	    {  str = astr[iIndex - 1];
	       astr[iIndex] = str.substring(str.length() - 1);
	    }
	    else
	    {  astr[iIndex - 1] = null;
	       astr[iIndex] = (String)_hashKana.get(strKana.substring(iIndex - 1, iIndex + 1));
	    }
	 }
      }

      return astr;
   }

   final private static String[] romanize(String[] astrPhonemes, String strKana)
   {  if (astrPhonemes == null)
      {  return null;
      }

      int cLength = astrPhonemes.length;
      String astrRoman[] = new String[cLength];
      for (int iIndex = 0; iIndex < cLength; iIndex++)
      {  String str = astrPhonemes[iIndex];
	 Object obj;
	 astrRoman[iIndex] = (str == null || (obj = _hashRoman.get(str)) == null
			      ? str
			      : (String)obj);
      }

      for (int iIndex = 0; iIndex < cLength; iIndex++)
      {  String str = astrRoman[iIndex];
	 if (str != null)
	 {  if (str.equals("u") || str.equals("o") || str.equals("i"))
	    {  String strPrev;
	       if (iIndex > 0
		   && (strPrev = astrRoman[iIndex - 1]) != null
		   && ((str.equals("u")
			&& (strPrev.endsWith("o") || strPrev.endsWith("u")))
		       || (str.equals("o") && strPrev.equals("to"))
		       || strKana.charAt(iIndex) == '['))
	       {  StringBuffer sb = new StringBuffer(strPrev);
		  int cLast = sb.length() - 1;
		  char c = sb.charAt(cLast);
		  sb.setCharAt(cLast, (c == 'o' ? '\u00f4'
				       : (c == 'u' ? '\u00fb' : '\u00ee')));
		  astrRoman[iIndex - 1] = null;
		  astrRoman[iIndex] = sb.toString();
	       }
	    }
	    else if (str.equals("n") || str.equals("Q"))
	    {  int iIndexNext = iIndex + 1;
	       while (iIndexNext < cLength)
	       {  String strNext = astrRoman[iIndexNext++];
		  if (strNext == null)
		  {  continue;
		  }

		  char c = strNext.charAt(0);
		  if (str.equals("n"))
		  {  if (c == 'm' || c == 'p' || c == 'b')
		     {  astrRoman[iIndex] = "m";
		     }
		     else if (c == 'a' || c == 'i' || c == 'u'
			      || c == 'e' || c == 'o' || c == 'y')
		     {  astrRoman[iIndex] = "n'";
		     }
		  }
		  else
		  {  astrRoman[iIndex] = String.valueOf(c == 'c' ? 't' : c);
		  }

		  break;
	       }
	    }
	 }
      }

      return astrRoman;
   }

   final void setNumber(String strNumber, String strNoun, String strCounter, int iMode)
   {  _strNoun = strNoun;
      _strCounter = strCounter;
      _iMode = iMode;
      setNumber(strNumber);
   }

   final void setNumber(String strNumber)
   {  _strNumber = strNumber;
      if (strNumber.length() == 0)
      {  _strNumberAndNoun = _strReading = "";
      }
      else
      {  _strNumberAndNoun = numberNoun(_strNumber, _strNoun);
	 _strReading = (_iMode == ModeModern
			? modernNumber(_strNumber, _strCounter)
			: (_iMode == ModeTraditional
			   ? traditionalNumber(_strNumber)
			   : dateNumber(_strNumber)));
      }

      _astrPhonemes = getPhoneme(_strReading);
      _astrRoman = romanize(_astrPhonemes, _strReading);
      setScrollbar();
      repaint(100);
   }

   final String numberNoun(String strNumber, String strNoun)
   {  int cbLength;
      if (strNoun == null
	  || (cbLength = strNumber.length()) == 0)
      {  return strNumber;
      }
      else
      {  StringBuffer sb = new StringBuffer(strNumber);
	 switch (_iMode)
	 {  case ModeModern:
	    {  sb.append(' ');
	       int cFirst;
	       if ((cFirst = strNumber.charAt(0)) == '0'
		   || (cFirst == '1'
		       && (cbLength == 1
			   || (strNumber.charAt(1) == '.'
			       && strNumber.substring(2).replace('0', ' ').trim().length() == 0))))
	       {  if (strNoun.equals("people"))
		  {  sb.append("person");
		  }
	          else
		  {  sb.append(strNoun);
		     if (!strNoun.equals("yen"))
		     {  sb.setLength(sb.length() - 1);
		     }
		  }
	       }
	       else
	       {  sb.append(strNoun);
	       }

	       return sb.toString();
	    }
	    case ModeDate:
	    {  int iNumber = Integer.parseInt(strNumber);
	       String strSuffix = "th";
	       if ((iNumber % 100) / 10 != 1)
	       {  switch (iNumber % 10)
		  {  case 1:
			strSuffix = "st";
			break;
		     case 2:
			strSuffix = "nd";
			break;
		     case 3:
			strSuffix = "rd";
			break;
		  }
	       }

	       return sb.append(strSuffix).append(' ').append(strNoun).toString();
	    }
	    default: /* ModeTraditional */
	       return sb.append(" (").append(strNoun).append(')').toString();
	 }
      }
   }

   final void modifyNumber(String strNumber, int iCarry)
   {  int iDigits = strNumber.length();
      if (iDigits == 0)
      {  if (iCarry > 0)
	 {  strNumber = "1";
	 }
	 else if (_iMode == ModeModern)
	 {  strNumber = "0";
	 }
	 else
	 {  return;
	 }
      }
      else
      {  int iPoint = strNumber.indexOf('.');
	 if (iPoint > 0)
	 {  iDigits = iPoint;
	 }

	 char acDigits[] = new char[iDigits];
	 strNumber.getChars(0, iDigits, acDigits, 0);
	 int iIndex = iDigits - 1;

	 while (iCarry != 0 && iIndex >= 0)
	 {  char c = (char)(acDigits[iIndex] + iCarry);
	    if (c < '0')
	    {  c = '9';
	    }
	    else if (c > '9')
	    {  c = '0';
	    }
	    else
	    {  iCarry = 0;
	    }

	    acDigits[iIndex--] = c;
	 }

	 if (iCarry < 0)
	 {  return;
	 }
	 
	 StringBuffer sb = new StringBuffer();
	 if (iCarry > 0)
	 {  sb.append('1');
	    sb.append(acDigits);
	 }
	 else
	 {  iIndex = 0;
	    while (iIndex < iDigits
		   && acDigits[iIndex] == '0')
	    {  iIndex++;
	    }

	    if (iIndex == iDigits)
	    {  iIndex--;
	    }

	    sb.append(acDigits, iIndex, iDigits - iIndex);
	 }

	 if (iPoint > 0)
	 {  sb.append(strNumber.substring(iPoint));
	 }

	 strNumber = sb.toString();
	 if (_iMode != ModeModern
	     && (strNumber.equals("0")
		 || strNumber.length() >= 6
		 || (_iMode == ModeDate
		     && Integer.parseInt(strNumber) >= 32)))
	 {  return;
	 }
      }

      setNumber(strNumber);
   }

   final public void keyPressed(KeyEvent ke)
   {  if (_fInit)
      {  int iKey = ke.getKeyCode();
	 String strNumber = _strNumber;

	 if (iKey == KeyEvent.VK_BACK_SPACE)
	 {  int cChars;
	    if ((cChars = strNumber.length()) != 0)
	    {  setNumber(strNumber.substring(0, cChars - 1));
	    }
	 }
	 else if (iKey == KeyEvent.VK_UP)
	 {  modifyNumber(strNumber, 1);
	 }
	 else if (iKey == KeyEvent.VK_DOWN)
	 {  modifyNumber(strNumber, -1);
	 }
      }
   }

   final public void keyReleased(KeyEvent ke)
   {
   }

   final public void keyTyped(KeyEvent ke)
   {  char cKey;
      if (_fInit
	  && ((cKey = ke.getKeyChar()) == '.'
	      || (cKey >= '0' && cKey <= '9')))
      {  String strNumber = _strNumber;
	 int cLength = strNumber.length();
	 boolean fOk;

	 switch (_iMode)
	 {  case ModeModern:
	       fOk = (cKey == '.'
		      ? (cLength != 0
			 && strNumber.indexOf('.') < 0)
		      : (cLength < _strLargeUnits.length * 4));
	       break;
	    case ModeTraditional:
	       fOk = (cKey != '.'
		      && (cLength == 0
			  ? (cKey != '0')
			  : (cLength <= 4)));
	       break;
	    default: /* ModeDate */
	       fOk = (cKey != '.'
		      && (cLength == 0
			  ? (cKey != '0')
			  : (cLength == 1
			     && (strNumber.charAt(0) - '0') * 10 + cKey - '0' <= 31)));
	       break;
	 }

	 if (fOk)
	 {  setNumber((cKey != '.'
		       && cLength == 1
		       && strNumber.charAt(0) == '0')
		      ? String.valueOf(cKey)
		      : (new StringBuffer(strNumber)).append(cKey).toString());
	 }
      }
   }

   final public void adjustmentValueChanged(AdjustmentEvent ae)
   {  _iScroll = _scrollbar.getValue();
      repaint();
   }

   final public void actionPerformed(ActionEvent ae)
   {  setNumber("");
      requestFocus();
   }

   final public void itemStateChanged(ItemEvent ie)
   {  ItemSelectable iselect = ie.getItemSelectable();
      Object obj = ie.getItem();

      if (iselect instanceof Choice)
      {  String str = (String)obj;

	 if (iselect == _choiceFont)
	 {  int iIndex = str.indexOf(',');
	    String strFont = str.substring(0, iIndex);
	    boolean fKata = (str.charAt(iIndex + 2) == 'K');

	    if (fKata != _fKata
		|| !strFont.equals(_strFont))
	    {  _strFont = strFont;
	       _fKata = fKata;

	       if (_thread != null)
	       {  _thread.stop();
	       }

	       _fInit = _fError = false;
	       (_thread = new Thread(this)).start();
	       repaint();
	    }
	 }
	 else
	 {  if (str.equals(_strNoCounter))
	    {  setNumber(_strNumber, null, null, ModeModern);
	    }
	    else
	    {  String strCounter = (String)_hashCounters.get(str);
	       String strNumber = _strNumber;
	       if (strCounter.equals("t")
		   || strCounter.equals("d"))
	       {  int iIndex = strNumber.indexOf('.');
		  if (iIndex >= 0)
		  {  strNumber = strNumber.substring(0, iIndex);
		  }

		  if (strCounter.equals("t"))
		  {  setNumber(((strNumber.length() <= 5
				 && !strNumber.equals("0"))
				? strNumber : ""),
			       str, null, ModeTraditional);
		  }
		  else
		  {  int cLength;
		     setNumber((((cLength = strNumber.length()) > 0
				 && cLength <= 2
				 && !strNumber.equals("0")
				 && Integer.parseInt(strNumber) <= 31)
				? strNumber : ""),
			       str, null, ModeDate);
		  }
	       }
	       else
	       {  setNumber(strNumber, str, strCounter, ModeModern);
	       }
	    }

	    repaint();
	 }
      }

      requestFocus();
   }     
}
